Attribute VB_Name = "WaveAudio"
Option Explicit

'********** API for Wave Audio ************

Public Type WaveFormatEx
    FormatTag As Integer
    Channels As Integer
    SamplesPerSec As Long
    AvgBytesPerSec As Long
    BlockAlign As Integer
    BitsPerSample As Integer
    ExtraDataSize As Integer
End Type

Public Type WaveHdr
    lpData As Long
    dwBufferLength As Long
    dwBytesRecorded As Long
    dwUser As Long
    dwFlags As Long
    dwLoops As Long
    lpNext As Long
    Reserved As Long
End Type

Public Type WaveInCaps
    ManufacturerID As Integer
    ProductID As Integer
    DriverVersion As Long
    ProductName(1 To 32) As Byte
    Formats As Long
    Channels As Integer
    Reserved As Integer
End Type

Public Const WAVE_INVALIDFORMAT = &H0&                 'invalid format
Public Const WAVE_FORMAT_1M08 = &H1&                   '11.025 kHz, Mono,   8-bit
Public Const WAVE_FORMAT_1S08 = &H2&                   '11.025 kHz, Stereo, 8-bit
Public Const WAVE_FORMAT_1M16 = &H4&                   '11.025 kHz, Mono,   16-bit
Public Const WAVE_FORMAT_1S16 = &H8&                   '11.025 kHz, Stereo, 16-bit
Public Const WAVE_FORMAT_2M08 = &H10&                  '22.05  kHz, Mono,   8-bit
Public Const WAVE_FORMAT_2S08 = &H20&                  '22.05  kHz, Stereo, 8-bit
Public Const WAVE_FORMAT_2M16 = &H40&                  '22.05  kHz, Mono,   16-bit
Public Const WAVE_FORMAT_2S16 = &H80&                  '22.05  kHz, Stereo, 16-bit
Public Const WAVE_FORMAT_4M08 = &H100&                 '44.1   kHz, Mono,   8-bit
Public Const WAVE_FORMAT_4S08 = &H200&                 '44.1   kHz, Stereo, 8-bit
Public Const WAVE_FORMAT_4M16 = &H400&                 '44.1   kHz, Mono,   16-bit
Public Const WAVE_FORMAT_4S16 = &H800&                 '44.1   kHz, Stereo, 16-bit

Public Const WAVE_FORMAT_PCM = 1

Public Const WHDR_DONE = &H1&
Public Const WHDR_PREPARED = &H2&
Public Const WHDR_BEGINLOOP = &H4&
Public Const WHDR_ENDLOOP = &H8&
Public Const WHDR_INQUEUE = &H10&

Public Const WIM_OPEN = &H3BE
Public Const WIM_CLOSE = &H3BF
Public Const WIM_DATA = &H3C0

Public Declare Function waveInAddBuffer Lib "winmm" (ByVal InputDeviceHandle As Long, ByVal WaveHdrPointer As Long, ByVal WaveHdrStructSize As Long) As Long
Public Declare Function waveInPrepareHeader Lib "winmm" (ByVal InputDeviceHandle As Long, ByVal WaveHdrPointer As Long, ByVal WaveHdrStructSize As Long) As Long
Public Declare Function waveInUnprepareHeader Lib "winmm" (ByVal InputDeviceHandle As Long, ByVal WaveHdrPointer As Long, ByVal WaveHdrStructSize As Long) As Long

Public Declare Function waveInGetNumDevs Lib "winmm" () As Long
Public Declare Function waveInGetDevCaps Lib "winmm" Alias "waveInGetDevCapsA" (ByVal uDeviceID As Long, ByVal WaveInCapsPointer As Long, ByVal WaveInCapsStructSize As Long) As Long

Public Declare Function waveInOpen Lib "winmm" (WaveDeviceInputHandle As Long, ByVal WhichDevice As Long, ByVal WaveFormatExPointer As Long, ByVal CallBack As Long, ByVal CallBackInstance As Long, ByVal Flags As Long) As Long
Public Declare Function waveInClose Lib "winmm" (ByVal WaveDeviceInputHandle As Long) As Long

Public Declare Function waveInStart Lib "winmm" (ByVal WaveDeviceInputHandle As Long) As Long
Public Declare Function waveInReset Lib "winmm" (ByVal WaveDeviceInputHandle As Long) As Long
Public Declare Function waveInStop Lib "winmm" (ByVal WaveDeviceInputHandle As Long) As Long

'general purpose timer
Public Declare Function timeGetTime Lib "winmm.dll" () As Long

